# include "stdio.h"
# define U(x) x
# define NLSTATE yyprevious=YYNEWLINE
# define BEGIN yybgin = yysvec + 1 +
# define INITIAL 0
# define YYLERR yysvec
# define YYSTATE (yyestate-yysvec-1)
# define YYOPTIM 1
# define YYLMAX 200
# define output(c) putc(c,yyout)
# define input() (((yytchar=yysptr>yysbuf?U(*--yysptr):getc(yyin))==10?(yylineno++,yytchar):yytchar)==EOF?0:yytchar)
# define unput(c) {yytchar= (c);if(yytchar=='\n')yylineno--;*yysptr++=yytchar;}
# define yymore() (yymorfg=1)
# define ECHO fprintf(yyout, "%s",yytext)
# define REJECT { nstr = yyreject(); goto yyfussy;}
int yyleng; extern char yytext[];
int yymorfg;
extern char *yysptr, yysbuf[];
int yytchar;
FILE *yyin ={stdin}, *yyout ={stdout};
extern int yylineno;
struct yysvf { 
	struct yywork *yystoff;
	struct yysvf *yyother;
	int *yystops;};
struct yysvf *yyestate;
extern struct yysvf yysvec[], *yybgin;
/* num_to_name.l: lexer for num_to_name.y  */

#include "y.tab.h"
#include <stdlib.h>
#define BUFSIZE 100

int commas_in( char *input);
char numbuf[BUFSIZE]; /* number with commas buffer */

# define ENGLISH 2
# define KNUTH 4
# define ENGLISHNUMBER 6
# define KNUTHNUMBER 8
# define YYNEWLINE 10
int yylex(){
int nstr; extern int yyprevious;
/* Code to pick the appropriate lexer */ 
	static int first_lex = 1;
	extern int start_state;

/* first_lex = 1 for English nomenclature, 2 for Knuthian */

	if(first_lex){
		if( start_state == 1 )
			BEGIN ENGLISH;
		else
			BEGIN KNUTH;
		first_lex = 0;  
	}
	

while((nstr = yylook()) >= 0)
yyfussy: switch(nstr){
case 0:
if(yywrap()) return(0); break;
case 1:
{/*It's a number not already processed: @ is processed
		number marker */
	 int i; 
	/* restore character that followed number */ 
	unput(yytext[yyleng-1]);
	/* put in end of number marker */  unput('@');
	/* push back rest of number in reverse order */
	 for(i=0;i<strlen(yytext)-1;i++)unput(yytext[i]);
		BEGIN KNUTHNUMBER;}
break;
case 2:
{  return EON;
	/* @: special marker for end of number */}
break;
case 3:
{/* not a number  */
		yylval.str = yytext;
		 return LITERAL;}
break;
case 4:
{  yylval.str = yytext; return WHITESPACE;}
break;
case 5:
{ BEGIN KNUTH;  yylval.str = yytext; return WHITESPACE;}
break;
case 6:
{ return yytext[0];  /* end of line */}
break;
case 7:
{BEGIN KNUTH; return yytext[0];  /* end of line */}
break;
case 8:
   { yylval.i = atoi(yytext); return DIGIT;}
break;
case 9:
{/*It's a number without commas: put 'em in */
	 int len; len = commas_in(yytext); 
	/* and push back onto input stream */
	 for(;len>0;len--)unput(numbuf[len-1]); BEGIN ENGLISHNUMBER;}
break;
case 10:
{/* not a number  */
		 yylval.str
		= yytext; return LITERAL;}
break;
case 11:
{yylval.str = yytext; return WHITESPACE;}
break;
case 12:
{yylval.str = yytext; BEGIN ENGLISH; return WHITESPACE;}
break;
case 13:
{return yytext[0];  /* end of line */}
break;
case 14:
{BEGIN ENGLISH; return yytext[0];  /* end of line */}
break;
case 15:
   { yylval.i = atoi(yytext);return EDIGIT;}
break;
case 16:
   {/* It must be a number. Begin processing as such */
	 unput(yytext[0]); BEGIN ENGLISHNUMBER;}
break;
case 17:
{return COMMA;}
break;
case 18:
{return 0;}
break;
case 19:
{return yytext[0];}
break;
case -1:
break;
default:
fprintf(yyout,"bad switch yylook %d",nstr);
} return(0); }
/* end of yylex */

/* commas_in: group digits in groups of 3 and punctuate with commas */
/* return string length of resulting number */

int commas_in( char *input)
{
	int len, ntriples, i;
	char *ptr;
	int count;

	ptr = input;
	len = strlen(input);
	ntriples = len/3;

/* initialize buffer */
	for(count=0;count<BUFSIZE;count++)numbuf[count]='\0';

/* handle odd digits at beginning, if necessary */

	if( len % 3 > 0 ) {
		strncpy(numbuf,input,len % 3);
		/* Put in a comma */
		strcat(numbuf,",");
	        ptr = ptr + ( len % 3) ;
		}

/* Put commas after each group of 3 digits */

	if (len > 3) {
		 for(i=1;i<ntriples;i++) {
			 strncat(numbuf,ptr,3);
			 ptr = ptr + 3;
			 strcat(numbuf,",");
			}

/* except the last group of 3 */

		  strncat(numbuf,ptr,3);
		 }
		
	return strlen(numbuf);
}	
int yyvstop[] ={
0,

19,
0,

10,
19,
0,

11,
19,
0,

13,
0,

10,
18,
19,
0,

16,
19,
0,

3,
19,
0,

4,
19,
0,

6,
0,

19,
0,

12,
19,
0,

14,
0,

17,
19,
0,

15,
19,
0,

5,
19,
0,

7,
0,

8,
19,
0,

2,
19,
0,

10,
0,

10,
0,

11,
0,

3,
0,

3,
0,

4,
0,

1,
0,

1,
0,

12,
0,

5,
0,

9,
0,
0};
# define YYTYPE unsigned char
struct yywork { YYTYPE verify, advance; } yycrank[] ={
0,0,	0,0,	1,11,	0,0,	
0,0,	3,12,	0,0,	5,17,	
0,0,	6,17,	1,11,	1,0,	
2,0,	3,13,	3,14,	5,18,	
5,19,	6,18,	6,19,	0,0,	
7,21,	7,22,	8,21,	8,22,	
9,25,	9,26,	0,0,	10,25,	
10,26,	0,0,	13,31,	0,0,	
0,0,	12,29,	0,0,	15,0,	
15,0,	4,15,	0,0,	18,36,	
3,15,	12,0,	12,0,	0,0,	
21,41,	1,11,	16,0,	16,0,	
3,11,	1,11,	25,42,	0,0,	
3,16,	13,31,	5,20,	7,23,	
6,20,	8,23,	15,0,	7,24,	
0,0,	8,24,	18,36,	9,27,	
12,0,	1,11,	10,27,	21,41,	
3,12,	16,0,	5,17,	0,0,	
6,17,	25,42,	0,0,	17,34,	
12,30,	0,0,	20,37,	9,28,	
12,30,	16,32,	10,28,	17,0,	
17,0,	16,33,	20,37,	20,37,	
29,0,	29,0,	34,0,	34,0,	
30,30,	32,0,	32,0,	0,0,	
12,29,	0,0,	0,0,	35,35,	
30,0,	30,0,	0,0,	0,0,	
33,0,	33,0,	17,0,	35,0,	
35,0,	0,0,	0,0,	29,0,	
0,0,	34,0,	0,0,	0,0,	
32,0,	0,0,	17,35,	43,0,	
43,0,	20,38,	17,35,	30,0,	
0,0,	20,39,	40,34,	33,0,	
32,32,	0,0,	35,0,	0,0,	
32,32,	0,0,	40,0,	40,0,	
0,0,	0,0,	17,34,	33,32,	
38,44,	20,40,	43,0,	33,43,	
38,44,	38,44,	38,44,	38,44,	
38,44,	38,44,	38,44,	38,44,	
38,44,	38,44,	43,32,	30,30,	
0,0,	40,0,	43,45,	0,0,	
38,40,	0,0,	35,35,	45,0,	
45,0,	0,0,	0,0,	0,0,	
0,0,	40,0,	0,0,	0,0,	
0,0,	40,0,	40,0,	40,0,	
40,0,	40,0,	40,0,	40,0,	
40,0,	40,0,	40,0,	0,0,	
0,0,	0,0,	45,0,	0,0,	
0,0,	40,34,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	45,32,	0,0,	
0,0,	0,0,	45,45,	0,0,	
0,0};
struct yysvf yysvec[] ={
0,	0,	0,
yycrank+-1,	0,		0,	
yycrank+-2,	yysvec+1,	0,	
yycrank+-4,	0,		0,	
yycrank+-1,	yysvec+3,	0,	
yycrank+-6,	yysvec+1,	0,	
yycrank+-8,	yysvec+1,	0,	
yycrank+-11,	yysvec+1,	0,	
yycrank+-13,	yysvec+1,	0,	
yycrank+-15,	yysvec+1,	0,	
yycrank+-18,	yysvec+1,	0,	
yycrank+0,	0,		yyvstop+1,
yycrank+-32,	0,		yyvstop+3,
yycrank+21,	0,		yyvstop+6,
yycrank+0,	0,		yyvstop+9,
yycrank+-26,	yysvec+12,	yyvstop+11,
yycrank+-37,	yysvec+12,	yyvstop+15,
yycrank+-74,	0,		yyvstop+18,
yycrank+30,	0,		yyvstop+21,
yycrank+0,	0,		yyvstop+24,
yycrank+-77,	0,		yyvstop+26,
yycrank+35,	0,		yyvstop+28,
yycrank+0,	0,		yyvstop+31,
yycrank+0,	0,		yyvstop+33,
yycrank+0,	0,		yyvstop+36,
yycrank+41,	0,		yyvstop+39,
yycrank+0,	0,		yyvstop+42,
yycrank+0,	0,		yyvstop+44,
yycrank+0,	0,		yyvstop+47,
yycrank+-79,	yysvec+12,	yyvstop+50,
yycrank+-91,	yysvec+12,	yyvstop+52,
yycrank+0,	yysvec+13,	yyvstop+54,
yycrank+-84,	yysvec+12,	0,	
yycrank+-95,	yysvec+12,	0,	
yycrank+-81,	yysvec+17,	yyvstop+56,
yycrank+-98,	yysvec+17,	yyvstop+58,
yycrank+0,	yysvec+18,	yyvstop+60,
yycrank+0,	0,		yyvstop+62,
yycrank+96,	0,		yyvstop+64,
yycrank+0,	yysvec+20,	0,	
yycrank+-125,	0,		0,	
yycrank+0,	yysvec+21,	yyvstop+66,
yycrank+0,	yysvec+25,	yyvstop+68,
yycrank+-110,	yysvec+12,	0,	
yycrank+0,	yysvec+38,	0,	
yycrank+-154,	yysvec+12,	yyvstop+70,
0,	0,	0};
struct yywork *yytop = yycrank+202;
struct yysvf *yybgin = yysvec+1;
char yymatch[] ={
00  ,01  ,01  ,01  ,01  ,01  ,01  ,01  ,
01  ,011 ,012 ,01  ,01  ,01  ,01  ,01  ,
01  ,01  ,01  ,01  ,01  ,01  ,01  ,01  ,
01  ,01  ,01  ,01  ,01  ,01  ,01  ,01  ,
011 ,01  ,01  ,01  ,01  ,01  ,01  ,01  ,
01  ,01  ,01  ,01  ,',' ,01  ,01  ,01  ,
'0' ,'0' ,'0' ,'0' ,'0' ,'0' ,'0' ,'0' ,
'0' ,'0' ,01  ,01  ,01  ,01  ,01  ,01  ,
'@' ,01  ,01  ,01  ,01  ,01  ,01  ,01  ,
01  ,01  ,01  ,01  ,01  ,01  ,01  ,01  ,
01  ,01  ,01  ,01  ,01  ,01  ,01  ,01  ,
01  ,01  ,01  ,01  ,01  ,01  ,01  ,01  ,
01  ,01  ,01  ,01  ,01  ,01  ,01  ,01  ,
01  ,01  ,01  ,01  ,01  ,01  ,01  ,01  ,
01  ,01  ,01  ,01  ,01  ,01  ,01  ,01  ,
01  ,01  ,01  ,01  ,01  ,01  ,01  ,01  ,
0};
char yyextra[] ={
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0};
/*	ncform	4.1	83/08/11	*/

int yylineno =1;
# define YYU(x) x
# define NLSTATE yyprevious=YYNEWLINE
char yytext[YYLMAX];
struct yysvf *yylstate [YYLMAX], **yylsp, **yyolsp;
char yysbuf[YYLMAX];
char *yysptr = yysbuf;
int *yyfnd;
extern struct yysvf *yyestate;
int yyprevious = YYNEWLINE;
#if	NeXT
int yylook(){
#else
yylook(){
#endif	NeXT
	register struct yysvf *yystate, **lsp;
	register struct yywork *yyt;
	struct yysvf *yyz;
	int yych;
	struct yywork *yyr;
# ifdef LEXDEBUG
	int debug;
# endif
	char *yylastch;
	/* start off machines */
# ifdef LEXDEBUG
	debug = 0;
# endif
	if (!yymorfg)
		yylastch = yytext;
	else {
		yymorfg=0;
		yylastch = yytext+yyleng;
		}
	for(;;){
		lsp = yylstate;
		yyestate = yystate = yybgin;
		if (yyprevious==YYNEWLINE) yystate++;
		for (;;){
# ifdef LEXDEBUG
			if(debug)fprintf(yyout,"state %d\n",yystate-yysvec-1);
# endif
			yyt = yystate->yystoff;
			if(yyt == yycrank){		/* may not be any transitions */
				yyz = yystate->yyother;
				if(yyz == 0)break;
				if(yyz->yystoff == yycrank)break;
				}
			*yylastch++ = yych = input();
		tryagain:
# ifdef LEXDEBUG
			if(debug){
				fprintf(yyout,"char ");
				allprint(yych);
				putchar('\n');
				}
# endif
			yyr = yyt;
			if ( (int)yyt > (int)yycrank){
				yyt = yyr + yych;
				if (yyt <= yytop && yyt->verify+yysvec == yystate){
					if(yyt->advance+yysvec == YYLERR)	/* error transitions */
						{unput(*--yylastch);break;}
					*lsp++ = yystate = yyt->advance+yysvec;
					goto contin;
					}
				}
# ifdef YYOPTIM
			else if((int)yyt < (int)yycrank) {		/* r < yycrank */
				yyt = yyr = yycrank+(yycrank-yyt);
# ifdef LEXDEBUG
				if(debug)fprintf(yyout,"compressed state\n");
# endif
				yyt = yyt + yych;
				if(yyt <= yytop && yyt->verify+yysvec == yystate){
					if(yyt->advance+yysvec == YYLERR)	/* error transitions */
						{unput(*--yylastch);break;}
					*lsp++ = yystate = yyt->advance+yysvec;
					goto contin;
					}
				yyt = yyr + YYU(yymatch[yych]);
# ifdef LEXDEBUG
				if(debug){
					fprintf(yyout,"try fall back character ");
					allprint(YYU(yymatch[yych]));
					putchar('\n');
					}
# endif
				if(yyt <= yytop && yyt->verify+yysvec == yystate){
					if(yyt->advance+yysvec == YYLERR)	/* error transition */
						{unput(*--yylastch);break;}
					*lsp++ = yystate = yyt->advance+yysvec;
					goto contin;
					}
				}
			if ((yystate = yystate->yyother) && (yyt= yystate->yystoff) != yycrank){
# ifdef LEXDEBUG
				if(debug)fprintf(yyout,"fall back to state %d\n",yystate-yysvec-1);
# endif
				goto tryagain;
				}
# endif
			else
				{unput(*--yylastch);break;}
		contin:
# ifdef LEXDEBUG
			if(debug){
				fprintf(yyout,"state %d char ",yystate-yysvec-1);
				allprint(yych);
				putchar('\n');
				}
# endif
			;
			}
# ifdef LEXDEBUG
		if(debug){
			fprintf(yyout,"stopped at %d with ",*(lsp-1)-yysvec-1);
			allprint(yych);
			putchar('\n');
			}
# endif
		while (lsp-- > yylstate){
			*yylastch-- = 0;
			if (*lsp != 0 && (yyfnd= (*lsp)->yystops) && *yyfnd > 0){
				yyolsp = lsp;
				if(yyextra[*yyfnd]){		/* must backup */
					while(yyback((*lsp)->yystops,-*yyfnd) != 1 && lsp > yylstate){
						lsp--;
						unput(*yylastch--);
						}
					}
				yyprevious = YYU(*yylastch);
				yylsp = lsp;
				yyleng = yylastch-yytext+1;
				yytext[yyleng] = 0;
# ifdef LEXDEBUG
				if(debug){
					fprintf(yyout,"\nmatch ");
					sprint(yytext);
					fprintf(yyout," action %d\n",*yyfnd);
					}
# endif
				return(*yyfnd++);
				}
			unput(*yylastch);
			}
		if (yytext[0] == 0  /* && feof(yyin) */)
			{
			yysptr=yysbuf;
			return(0);
			}
		yyprevious = yytext[0] = input();
		if (yyprevious>0)
			output(yyprevious);
		yylastch=yytext;
# ifdef LEXDEBUG
		if(debug)putchar('\n');
# endif
		}
	}
#if	NeXT
int yyback(p, m)
	int *p;
	int m;
#else
yyback(p, m)
	int *p;
#endif	NeXT
{
if (p==0) return(0);
while (*p)
	{
	if (*p++ == m)
		return(1);
	}
return(0);
}
	/* the following are only used in the lex library */
#if	NeXT
int yyinput(){
#else
yyinput(){
#endif	NeXT
	return(input());
	}
#if	NeXT
void yyoutput(c)
	int c; 
{
	output(c);
}
#else
yyoutput(c)
  int c; {
	output(c);
	}
#endif	NeXT
#if	NeXT
void yyunput(c)
	int c; 
{
	unput(c);
}
#else
yyunput(c)
   int c; {
	unput(c);
	}
#endif	NeXT
