
# line 2 "num_to_name.y"
/* num_to_name.y: Yacc grammer for number-to-English filter. */
          /* ( Programming exercise, 1/94 ) */
/*

	usage: num_to_name [-k] [< input] [> output]

	options: k: use Knuth's nomenclature instead
			of standard English.
Default:  (English)
*/
/* Parsing assumes the number has commas, e.g., 1,102,001 */
/* The lexer (num_to_name.l) ensures this is the case */
/* This is a filter: it passes non-numbers on through, and
	changes numbers to english, e.g
 I saw 121 girls -> I saw one hundred twenty one girls

/* With the -k option:
*/
/* Parsing assumes numbers come in in reverse */
/* The lexer (num_knuth.l) ensures this is the case */
/* This is a filter: it passes non-numbers on through, and
	changes numbers to Knuth nomenclature, e.g
 I saw 121344 girls -> I saw twelve myriad, thirteen hundred 
 forty four girls

For a description of Knuth's nomenclature,

D.E.Knuth,"Supernatural Numbers," The Mathematical Gardner,
Wadsworth International, 1981, 310-323.

bugs:	Won't handle decimals.
	Won't handle numbers at the end of a sentence or with
		other punctuation right after them as numbers.
	Won't handle ordinals, e.g 2nd -> second
	Expansion on numbers may make lines very long
	"Only" goes up to decillions. No undecillions.
	In -k option:
	There are reduce/reduce conflicts. Is there a way to do this
	without them? The default shift resolution works here because
	of the ordering of rules.

*/

#include <string.h>
#include <stdio.h>
#include <stdlib.h>

#define TRUE 0
#define TRUE 0
#define FALSE 1
#define BUFSIZE 1000
#define DENOMINATIONS 10 /*  tens, hundreds, myriads, ... */

char names[DENOMINATIONS * DENOMINATIONS][BUFSIZE];
/* Used to store names of each denomination. For example, with
12344321, "forty three hundred twenty one" is the name of the
hundreds denomination, and "twelve hundred thirty four" is the name
of the myriads denomination. These must be stored in separate
locations because names of lower denominations get used to build names
of higher ones */
int indx = 0;
char *name( int triad );  /* Names numbers in range 00-999 */
char *kname( int diad );  /* Names numbers in range 00-99 */
/* used with -k option */
void clearbuf( char *first, int size ); /* does what it says */
void wipe(void); /* reinitialize the big names buffer */
int start_state = 1; /* default. 1 means English, 2 means Knuthian */
char buf[BUFSIZE];          /* number buffer */
char *prepend(const char *, char *); /* supplement to string.h */
char localbuf[BUFSIZE]; /* used by prepend */

static char *digit_names[] = { "", " one", " two", " three",
	" four", " five", " six", " seven", " eight", " nine"};

static char *teen_names[] = { " ten", " eleven", " twelve", 
	" thirteen", " fourteen", " fifteen", " sixteen", 
	" seventeen", " eighteen", " nineteen"};

static char *tens_names[] = { " twenty", " thirty", " forty",
	" fifty", " sixty", " seventy", " eighty", " ninety"};



# line 86 "num_to_name.y"
typedef union  {int i;
	char *str;
	 } YYSTYPE;
# define COMMA 257
# define LITERAL 258
# define WHITESPACE 259
# define DIGIT 260
# define EDIGIT 261
# define EON 262
#define yyclearin yychar = -1
#define yyerrok yyerrflag = 0
extern int yychar;
extern short yyerrflag;
#ifndef YYMAXDEPTH
#define YYMAXDEPTH 150
#endif
YYSTYPE yylval, yyval;
# define YYERRCODE 256

# line 364 "num_to_name.y"


int main(int argc, char *argv[]) 
{
	char c;
	while (--argc > 0 && (*++argv)[0] == '-')
		while ( c = *++argv[0])
		switch (c) {
		case 'k':
			 start_state = 2;       /* handle option(s) */
			break;
		default:
			printf("num_to_name: illegal option %c\n", c);
			return 1;
		}
			
	yyparse();
	return 0;
}


char *prepend(const char *first, char *second)

/* Stick first on front of second, return second */
{
	char temp[BUFSIZE];

	strcpy(temp,first);  /* store first in temp */
	strcat(temp,second); /* tack on second */
	strcpy(second,temp);
	return second;
}

char *name( int triad)
/* returns pointer to the English phrase for a number from 001 - 999 */
{
	int ones,tens,hundreds; /* digits */

	clearbuf(localbuf,sizeof(localbuf));
	
	hundreds = triad/100;
	tens = (triad - hundreds*100)/10;
	ones = (triad - hundreds*100 - tens*10);

	if( tens == 0) sprintf(localbuf,"%s",digit_names[ones]);
	else 
	{    if( tens == 1)
		sprintf(localbuf,"%s",teen_names[ones]);
		else {
			sprintf(localbuf,"%s",digit_names[ones]);
			prepend(tens_names[tens-2],localbuf);
		     }  /* starts with "twenty" ^  */
	}
	if(hundreds !=0) {
		prepend(" hundred", localbuf);
		prepend(digit_names[hundreds],localbuf);
	}
	return localbuf;
}

void clearbuf( char *first, int size )
{
	int i;
	for(i=0;i<size;i++) *(first + i) = '\0';
	return ;
}

char *kname( int diad)
/* returns pointer to the English phrase for a number from 01 - 99 */
{
	int ones,tens; /* digits */
		clearbuf(localbuf,BUFSIZE);
	
	tens = diad/10;
	ones = (diad - tens*10);

	if( tens == 0) sprintf(localbuf,"%s",digit_names[ones]);
	else 
	{    if( tens == 1)
		sprintf(localbuf,"%s",teen_names[ones]);
		else {
			sprintf(localbuf,"%s",
			tens_names[tens-2]);
			strcat(localbuf,digit_names[ones]);
		     	}
	}
	return localbuf;
}

/* wipe: clear the big names buffer */
void wipe(void)
{	
	int count;

	for(count=0;count< DENOMINATIONS * DENOMINATIONS; count++)
		clearbuf(names[count],BUFSIZE);
	return;
}


short yyexca[] ={
-1, 1,
	0, -1,
	-2, 0,
	};
# define YYNPROD 75
# define YYLAST 256
short yyact[]={

  39,  69,  44,  70,   4,  37,  37,  68,  65,  37,
  37,  62,  59,  37,  37,  56,  48,  38,  83,  71,
 103, 101,  99,  97,  95,  93,  91,  89,  87,  84,
  45,  30,  18,  19,  53,  36,  28,  52,  28,  27,
  51,  27,  26,  32,  26,   8,  35,  25,  34,  43,
  72,  20,  24,  33,  23,  74,  31,  17,  75,  17,
  16,  76,  16,  15,  77,  15,  14,   3,  14,   2,
   7,  67,  66,  64,  42,  61,  54,  82,  73,  50,
  50,  58,  63,  60,  49,  55,  47,  57,  46,  78,
  79,  13,  12,  13,  12,  80,  81,  11,  10,  11,
  10,   6,   5,   1,  22,  41,  40,  21,   0,   0,
   0,   0,   0,   0,   0,   0,  86,   0,  85,  88,
  73,  90,   0,  92,   0,  94,   0,  96,   0,  98,
   0, 100,   0, 102,   0, 104,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   9,  29,
  37,  38,   9,  29,  37,  38 };
short yypact[]={

-1000,  -6,-1000, -10,-1000,-1000,-1000,-1000,-1000,-1000,
-1000,-1000,-1000,-1000,-1000,-1000,-1000,-1000,-1000,-1000,
-1000,-260,-1000,-1000,-1000,-1000,-1000,-1000,-1000,-1000,
-227,-246,-247,-250,-251,-254,-255,-259,-242,-1000,
-1000,-1000,-1000,-1000,-1000,-244,-1000,-1000,-1000,-1000,
-1000,-1000,-1000,-1000,-1000,-1000,-1000,-1000,-1000,-1000,
-1000,-1000,-1000,-1000,-1000,-1000,-1000,-1000,-1000,-1000,
-1000,-243,-1000,-1000,-1000,-1000,-1000,-1000,-1000,-1000,
-1000,-1000,-228,-1000,-244,-1000,-229,-244,-230,-244,
-231,-244,-232,-244,-233,-244,-234,-244,-235,-244,
-236,-244,-237,-244,-1000 };
short yypgo[]={

   0,  31,  35,  34,  46,  96,  37,  48,  40,  53,
  47,  43,  52,  56,  54, 107, 104, 103,  69,  67,
 102, 101,  70,  45,  95,  90,  89,  64,  61,  58,
  55,  32,  33,  51,  50 };
short yyr1[]={

   0,  17,  17,  18,  18,  19,  19,  19,  19,  19,
  19,  19,  19,  23,  20,  21,  21,  21,  21,  21,
  21,  21,  21,  21,  21,  21,  33,  34,  32,  31,
  30,  29,  28,  27,  26,  25,  24,   5,   1,   1,
   1,  22,  22,  22,  22,  22,  22,  22,  22,  15,
  16,  16,  16,  13,  14,  14,  14,  11,  12,  12,
  12,   9,  10,  10,  10,   7,   8,   8,   8,   4,
   6,   6,   6,   2,   3 };
short yyr2[]={

   0,   0,   2,   2,   1,   2,   2,   2,   2,   1,
   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,
   1,   1,   1,   1,   1,   1,   3,   3,   3,   3,
   3,   3,   3,   3,   3,   3,   3,   1,   3,   2,
   1,   2,   1,   1,   1,   1,   1,   1,   1,   2,
   2,   2,   1,   2,   2,   2,   1,   2,   2,   2,
   1,   2,   2,   2,   1,   2,   2,   2,   1,   2,
   2,   2,   1,   2,   2 };
short yychk[]={

-1000, -17, -18, -19,  10, -20, -21, -22, -23, 258,
  -5, -24, -25, -26, -27, -28, -29, -30, -31, -32,
 -33, -15, -16, -14, -12, -10,  -8,  -6,  -3, 259,
  -1, -13, -11,  -9,  -7,  -4,  -2, 260, 261,  10,
 -20, -21, -22, -23, 262, 257, -13, -14, 262, -12,
 -10,  -8,  -6,  -3, -11, -12, 262,  -9, -10, 262,
  -7,  -8, 262,  -4,  -6, 262,  -2,  -3, 262, 260,
 262, 261, -34, -31, -30, -29, -28, -27, -26, -25,
 -24,  -5,  -1, 261, 257, -32,  -1, 257,  -1, 257,
  -1, 257,  -1, 257,  -1, 257,  -1, 257,  -1, 257,
  -1, 257,  -1, 257,  -1 };
short yydef[]={

   1,  -2,   2,   0,   4,   9,  10,  11,  12,  14,
  15,  16,  17,  18,  19,  20,  21,  22,  23,  24,
  25,   0,  42,  43,  44,  45,  46,  47,  48,  13,
  37,   0,   0,   0,   0,   0,   0,   0,  40,   3,
   5,   6,   7,   8,  41,   0,  49,  50,  51,  56,
  60,  64,  68,  72,  53,  54,  55,  57,  58,  59,
  61,  62,  63,  65,  66,  67,  69,  70,  71,  73,
  74,  39,  26,  28,  29,  30,  31,  32,  33,  34,
  35,  36,  37,  38,   0,  27,  37,   0,  37,   0,
  37,   0,  37,   0,  37,   0,  37,   0,  37,   0,
  37,   0,   0,   0,  37 };
# line 1 "/usr/lib/yaccpar"
#ifndef lint
static char yaccpar_sccsid[] = "@(#)yaccpar	4.1	(Berkeley)	2/11/83";
#endif not lint

# define YYFLAG -1000
# define YYERROR goto yyerrlab
# define YYACCEPT return(0)
# define YYABORT return(1)

/*	parser for yacc output	*/

#ifdef YYDEBUG
int yydebug = 0; /* 1 for debugging */
#endif
YYSTYPE yyv[YYMAXDEPTH]; /* where the values are stored */
int yychar = -1; /* current input token number */
int yynerrs = 0;  /* number of errors */
short yyerrflag = 0;  /* error recovery flag */

yyparse() {

	short yys[YYMAXDEPTH];
	short yyj, yym;
	register YYSTYPE *yypvt;
	register short yystate, *yyps, yyn;
	register YYSTYPE *yypv;
	register short *yyxi;

	yystate = 0;
	yychar = -1;
	yynerrs = 0;
	yyerrflag = 0;
	yyps= &yys[-1];
	yypv= &yyv[-1];

 yystack:    /* put a state and value onto the stack */

#ifdef YYDEBUG
	if( yydebug  ) printf( "state %d, char 0%o\n", yystate, yychar );
#endif
		if( ++yyps>= &yys[YYMAXDEPTH] ) { yyerror( "yacc stack overflow" ); return(1); }
		*yyps = yystate;
		++yypv;
		*yypv = yyval;

 yynewstate:

	yyn = yypact[yystate];

	if( yyn<= YYFLAG ) goto yydefault; /* simple state */

	if( yychar<0 ) if( (yychar=yylex())<0 ) yychar=0;
	if( (yyn += yychar)<0 || yyn >= YYLAST ) goto yydefault;

	if( yychk[ yyn=yyact[ yyn ] ] == yychar ){ /* valid shift */
		yychar = -1;
		yyval = yylval;
		yystate = yyn;
		if( yyerrflag > 0 ) --yyerrflag;
		goto yystack;
		}

 yydefault:
	/* default state action */

	if( (yyn=yydef[yystate]) == -2 ) {
		if( yychar<0 ) if( (yychar=yylex())<0 ) yychar = 0;
		/* look through exception table */

		for( yyxi=yyexca; (*yyxi!= (-1)) || (yyxi[1]!=yystate) ; yyxi += 2 ) ; /* VOID */

		while( *(yyxi+=2) >= 0 ){
			if( *yyxi == yychar ) break;
			}
		if( (yyn = yyxi[1]) < 0 ) return(0);   /* accept */
		}

	if( yyn == 0 ){ /* error */
		/* error ... attempt to resume parsing */

		switch( yyerrflag ){

		case 0:   /* brand new error */

			yyerror( "syntax error" );
		yyerrlab:
			++yynerrs;

		case 1:
		case 2: /* incompletely recovered error ... try again */

			yyerrflag = 3;

			/* find a state where "error" is a legal shift action */

			while ( yyps >= yys ) {
			   yyn = yypact[*yyps] + YYERRCODE;
			   if( yyn>= 0 && yyn < YYLAST && yychk[yyact[yyn]] == YYERRCODE ){
			      yystate = yyact[yyn];  /* simulate a shift of "error" */
			      goto yystack;
			      }
			   yyn = yypact[*yyps];

			   /* the current yyps has no shift onn "error", pop stack */

#ifdef YYDEBUG
			   if( yydebug ) printf( "error recovery pops state %d, uncovers %d\n", *yyps, yyps[-1] );
#endif
			   --yyps;
			   --yypv;
			   }

			/* there is no state on the stack with an error shift ... abort */

	yyabort:
			return(1);


		case 3:  /* no shift yet; clobber input char */

#ifdef YYDEBUG
			if( yydebug ) printf( "error recovery discards char %d\n", yychar );
#endif

			if( yychar == 0 ) goto yyabort; /* don't discard EOF, quit */
			yychar = -1;
			goto yynewstate;   /* try again in the same state */

			}

		}

	/* reduction by production yyn */

#ifdef YYDEBUG
		if( yydebug ) printf("reduce %d\n",yyn);
#endif
		yyps -= yyr2[yyn];
		yypvt = yypv;
		yypv -= yyr2[yyn];
		yyval = yypv[1];
		yym=yyn;
			/* consult goto table to find next state */
		yyn = yyr1[yyn];
		yyj = yypgo[yyn] + *yyps + 1;
		if( yyj>=YYLAST || yychk[ yystate = yyact[yyj] ] != -yyn ) yystate = yyact[yypgo[yyn]];
		switch(yym){
			
case 3:
# line 116 "num_to_name.y"
{printf("\n");} break;
case 4:
# line 117 "num_to_name.y"
{printf("\n");} break;
case 6:
# line 121 "num_to_name.y"
{clearbuf(buf,sizeof(buf));/* prepare for
					next  number */} break;
case 10:
# line 126 "num_to_name.y"
{clearbuf(buf,sizeof(buf));} break;
case 13:
# line 131 "num_to_name.y"
{ printf("%s",yypvt[-0].str);/* pass through whitespace */} break;
case 14:
# line 134 "num_to_name.y"
{printf("%s",yypvt[-0].str);/* pass through non-numbers */} break;
case 15:
# line 137 "num_to_name.y"
{buf[ (int) strlen(buf)-1 ] = '\0'; /* kill last ,*/
			 printf("%s",buf+1);/* eat up leading space*/} break;
case 16:
# line 139 "num_to_name.y"
{buf[ (int) strlen(buf)-1 ] = '\0'; printf("%s",buf+1);} break;
case 17:
# line 140 "num_to_name.y"
{buf[ (int) strlen(buf)-1 ] = '\0'; printf("%s",buf+1);} break;
case 18:
# line 141 "num_to_name.y"
{buf[ (int) strlen(buf)-1 ] = '\0';printf("%s",buf+1);} break;
case 19:
# line 142 "num_to_name.y"
{buf[ (int) strlen(buf)-1 ] = '\0';printf("%s",buf+1);} break;
case 20:
# line 143 "num_to_name.y"
{buf[ (int) strlen(buf)-1 ] = '\0';printf("%s",buf+1);} break;
case 21:
# line 144 "num_to_name.y"
{buf[ (int) strlen(buf)-1 ] = '\0';printf("%s",buf+1);} break;
case 22:
# line 145 "num_to_name.y"
{buf[ (int) strlen(buf)-1 ] = '\0';printf("%s",buf+1);} break;
case 23:
# line 146 "num_to_name.y"
{buf[ (int) strlen(buf)-1 ] = '\0';printf("%s",buf+1);} break;
case 24:
# line 147 "num_to_name.y"
{buf[ (int) strlen(buf)-1 ] = '\0';printf("%s",buf+1);} break;
case 25:
# line 148 "num_to_name.y"
{buf[ (int) strlen(buf)-1 ] = '\0';printf("%s",buf+1);} break;
case 26:
# line 151 "num_to_name.y"
{ prepend( " decillion,", buf);
			    prepend( name(yypvt[-2].i), buf); } break;
case 27:
# line 154 "num_to_name.y"
{  if( strlen(name(yypvt[-2].i)) > 0)/*not 000*/
			prepend( " nonillion,", buf);
			    prepend( name(yypvt[-2].i), buf); } break;
case 28:
# line 158 "num_to_name.y"
{  if( strlen(name(yypvt[-2].i)) > 0)
			prepend( " octillion,", buf);
			    prepend( name(yypvt[-2].i), buf); } break;
case 29:
# line 162 "num_to_name.y"
{  if( strlen(name(yypvt[-2].i)) > 0)
			prepend( " septillion,", buf);
			    prepend( name(yypvt[-2].i), buf); } break;
case 30:
# line 166 "num_to_name.y"
{  if( strlen(name(yypvt[-2].i)) > 0)
			prepend( " sextillion,", buf);
			    prepend( name(yypvt[-2].i), buf); } break;
case 31:
# line 170 "num_to_name.y"
{  if( strlen(name(yypvt[-2].i)) > 0)
			prepend( " quintillion,", buf);
			    prepend( name(yypvt[-2].i), buf); } break;
case 32:
# line 174 "num_to_name.y"
{  if( strlen(name(yypvt[-2].i)) > 0)
			prepend( " quadrillion,", buf);
			    prepend( name(yypvt[-2].i), buf); } break;
case 33:
# line 179 "num_to_name.y"
{  if( strlen(name(yypvt[-2].i)) > 0)
			prepend( " trillion,", buf);
			    prepend( name(yypvt[-2].i), buf); } break;
case 34:
# line 184 "num_to_name.y"
{  if( strlen(name(yypvt[-2].i)) > 0)
			prepend( " billion,", buf);
			    prepend( name(yypvt[-2].i), buf); } break;
case 35:
# line 189 "num_to_name.y"
{  if( strlen(name(yypvt[-2].i)) > 0)
			prepend( " million,", buf);
			    prepend( name(yypvt[-2].i), buf); } break;
case 36:
# line 194 "num_to_name.y"
{  if( strlen(name(yypvt[-2].i)) > 0)
				prepend( " thousand,", buf);
			    prepend( name(yypvt[-2].i), buf); } break;
case 37:
# line 199 "num_to_name.y"
{ if( strlen(name(yypvt[-0].i)) > 0)
	sprintf( buf, "%s,", name(yypvt[-0].i)); } break;
case 38:
# line 203 "num_to_name.y"
{ yyval.i = 100*yypvt[-2].i + 10*yypvt[-1].i + yypvt[-0].i;} break;
case 39:
# line 204 "num_to_name.y"
{yyval.i = 10*yypvt[-1].i + yypvt[-0].i;} break;
case 40:
# line 205 "num_to_name.y"
{yyval.i = yypvt[-0].i;} break;
case 41:
# line 208 "num_to_name.y"
{printf("%s",yypvt[-1].str);wipe();} break;
case 42:
# line 209 "num_to_name.y"
{printf("%s",yypvt[-0].str);wipe();} break;
case 43:
# line 210 "num_to_name.y"
{printf("%s",yypvt[-0].str);wipe();} break;
case 44:
# line 211 "num_to_name.y"
{printf("%s",yypvt[-0].str);wipe();} break;
case 45:
# line 212 "num_to_name.y"
{printf("%s",yypvt[-0].str);wipe();} break;
case 46:
# line 213 "num_to_name.y"
{printf("%s",yypvt[-0].str);wipe();} break;
case 47:
# line 214 "num_to_name.y"
{printf("%s",yypvt[-0].str);wipe();} break;
case 48:
# line 215 "num_to_name.y"
{printf("%s",yypvt[-0].str);wipe();} break;
case 49:
# line 220 "num_to_name.y"
{ char *ptr = &names[indx][0]; clearbuf(ptr,BUFSIZE); 
		strcpy(ptr,yypvt[-0].str);
		if(*ptr != '\0')
		strcat(ptr, " quadryllion");
	        yyval.str = strcat(ptr,yypvt[-1].str);
		indx++;
		} break;
case 50:
# line 228 "num_to_name.y"
{ char *ptr = &names[indx][0];
		 clearbuf(ptr,BUFSIZE); 
		strcpy(ptr,yypvt[-0].str);
		strcat(ptr, " quadryllion");
	        yyval.str = strcat(ptr,yypvt[-1].str);
		indx++;
		} break;
case 51:
# line 235 "num_to_name.y"
{ char *ptr = &names[indx][0];
		 clearbuf(ptr,BUFSIZE); 
	        yyval.str = strcpy(ptr,yypvt[-1].str);
		indx++;} break;
case 52:
# line 240 "num_to_name.y"
{/* produces conflict */ } break;
case 53:
# line 242 "num_to_name.y"
{ char *ptr = &names[indx][0]; clearbuf(ptr,BUFSIZE); 
		strcpy(ptr,yypvt[-0].str);
		if(*ptr != '\0')
		strcat(ptr, " tryllion");
	        yyval.str = strcat(ptr,yypvt[-1].str);
		indx++;
		} break;
case 54:
# line 250 "num_to_name.y"
{ char *ptr = &names[indx][0];
		 clearbuf(ptr,BUFSIZE); 
		strcpy(ptr,yypvt[-0].str);
		strcat(ptr, " tryllion");
	        yyval.str = strcat(ptr,yypvt[-1].str);
		indx++;
		} break;
case 55:
# line 257 "num_to_name.y"
{ char *ptr = &names[indx][0];
		 clearbuf(ptr,BUFSIZE); 
	        yyval.str = strcpy(ptr,yypvt[-1].str);
		indx++;} break;
case 56:
# line 262 "num_to_name.y"
{/* produces conflict */ } break;
case 57:
# line 265 "num_to_name.y"
{ char *ptr = &names[indx][0]; clearbuf(ptr,BUFSIZE); 
		strcpy(ptr,yypvt[-0].str);
		if(*ptr != '\0')
		strcat(ptr, " byllion");
	        yyval.str = strcat(ptr,yypvt[-1].str);
		indx++;
		} break;
case 58:
# line 273 "num_to_name.y"
{ char *ptr = &names[indx][0];
		 clearbuf(ptr,BUFSIZE); 
		strcpy(ptr,yypvt[-0].str);
		strcat(ptr, " byllion");
	        yyval.str = strcat(ptr,yypvt[-1].str);
		indx++;
		} break;
case 59:
# line 280 "num_to_name.y"
{ char *ptr = &names[indx][0];
		 clearbuf(ptr,BUFSIZE); 
	        yyval.str = strcpy(ptr,yypvt[-1].str);
		indx++;} break;
case 60:
# line 285 "num_to_name.y"
{/* produces conflict */ } break;
case 61:
# line 288 "num_to_name.y"
{ char *ptr = &names[indx][0]; clearbuf(ptr,BUFSIZE); 
		strcpy(ptr,yypvt[-0].str);
		if(*ptr != '\0')
		strcat(ptr, " myllion");
	        yyval.str = strcat(ptr,yypvt[-1].str);
		indx++;
		} break;
case 62:
# line 296 "num_to_name.y"
{ char *ptr = &names[indx][0];
		 clearbuf(ptr,BUFSIZE); 
		strcpy(ptr,yypvt[-0].str);
		strcat(ptr, " myllion");
	        yyval.str = strcat(ptr,yypvt[-1].str);
		indx++;
		} break;
case 63:
# line 303 "num_to_name.y"
{ char *ptr = &names[indx][0];
		 clearbuf(ptr,BUFSIZE); 
	        yyval.str = strcpy(ptr,yypvt[-1].str);
		indx++;} break;
case 64:
# line 308 "num_to_name.y"
{/* produces conflict */ } break;
case 65:
# line 311 "num_to_name.y"
{ char *ptr = &names[indx][0]; clearbuf(ptr,BUFSIZE); 
		strcpy(ptr,yypvt[-0].str);
		if(*ptr != '\0')
		strcat(ptr, " myriad");
	        yyval.str = strcat(ptr,yypvt[-1].str);
		indx++;
		} break;
case 66:
# line 319 "num_to_name.y"
{ char *ptr = &names[indx][0];
		 clearbuf(ptr,BUFSIZE); 
		strcpy(ptr,yypvt[-0].str);
		strcat(ptr, " myriad");
	        yyval.str = strcat(ptr,yypvt[-1].str);
		indx++;
		} break;
case 67:
# line 326 "num_to_name.y"
{ char *ptr = &names[indx][0];
		 clearbuf(ptr,BUFSIZE); 
	        yyval.str = strcpy(ptr,yypvt[-1].str);
		indx++;} break;
case 68:
# line 331 "num_to_name.y"
{/* produces conflict */ } break;
case 69:
# line 334 "num_to_name.y"
{ char *ptr = &names[indx][0]; clearbuf(ptr,BUFSIZE); 
		strcpy(ptr,yypvt[-0].str);
		if(*ptr != '\0')
		strcat(ptr, " hundred");
	        yyval.str = strcat(ptr,yypvt[-1].str);
		indx++;
		} break;
case 70:
# line 342 "num_to_name.y"
{ char *ptr = &names[indx][0];
		 clearbuf(ptr,BUFSIZE); 
		strcpy(ptr,yypvt[-0].str);
		strcat(ptr, " hundred");
	        yyval.str = strcat(ptr,yypvt[-1].str);
		indx++;
		} break;
case 71:
# line 349 "num_to_name.y"
{ char *ptr = &names[indx][0];
		 clearbuf(ptr,BUFSIZE); 
	        yyval.str = strcpy(ptr,yypvt[-1].str);
		indx++;} break;
case 72:
# line 354 "num_to_name.y"
{ /* produces conflict */ } break;
case 73:
# line 357 "num_to_name.y"
{char *ptr = &names[indx][0];clearbuf(ptr,BUFSIZE);
		 strcpy(ptr, kname(10*yypvt[-0].i + yypvt[-1].i)); yyval.str = ptr;indx++;} break;
case 74:
# line 360 "num_to_name.y"
{char *ptr = &names[indx][0];clearbuf(ptr,BUFSIZE);
		 strcpy(ptr, digit_names[yypvt[-1].i]); yyval.str = ptr;indx++;} break;
# line 148 "/usr/lib/yaccpar"

		}
		goto yystack;  /* stack new state and value */

	}
